﻿using System;
using System.IO;
using System.Xml.Serialization;

namespace Programming_CSharp
{
    // Prosta klasa klienta
    public class Customer
    {
        public string FirstName { get; set; }
        public string LastName { get; set; }
        public string EmailAddress { get; set; }

        // Metoda przesłaniająca metodę Object.ToString(), która zwraca tekstową postać właściwości obiektu.
        public override string ToString()
        {
            return string.Format("{0} {1}\nEmail: {2}", FirstName, LastName, EmailAddress);
        }
    }

    // Główny program
    public class Tester
    {
        static void Main()
        {
            Customer c1 = new Customer
            {
                FirstName = "Marian",
                LastName = "Opania",
                EmailAddress = "marian0@onet.pl"
            };

            XmlSerializer serializer = new XmlSerializer(typeof(Customer));
            StringWriter writer = new StringWriter();
            serializer.Serialize(writer, c1);

            string xml = writer.ToString();
            Console.WriteLine("Klient w XML:\n{0}\n", xml);

            Customer c2 = serializer.Deserialize(new StringReader(xml)) as Customer;
            Console.WriteLine("Klient w Object:\n{0}", c2.ToString());

            Console.ReadKey();
        }
    }
}